/*
 * Decompiled with CFR 0.152.
 */
package cds.tools;

import cds.aladin.MyInputStream;
import cds.tools.Util;
import java.net.HttpURLConnection;
import java.net.URL;

public class UrlLoader
extends Thread {
    private URL url;
    private StringBuffer res = new StringBuffer();
    private long timeout;
    private String error = null;
    private HttpURLConnection conn = null;
    private MyInputStream is = null;
    private boolean isWaiting = true;
    private int length = -1;
    private int size = 0;

    public UrlLoader(URL url, int timeout, int mode) throws Exception {
        this(url, timeout);
        if (mode > 0) {
            this.getData(mode == 1 ? 0 : -1);
        }
    }

    public UrlLoader(URL url, int timeout) {
        this.timeout = timeout;
        this.url = url;
    }

    public String getData() throws Exception {
        return this.getData(-1);
    }

    public String getData(int length) throws Exception {
        if (this.res != null && this.res.length() != 0) {
            return this.res.toString();
        }
        this.length = length;
        long t1 = System.currentTimeMillis();
        this.start();
        while (this.isWaiting && System.currentTimeMillis() - t1 < this.timeout) {
            try {
                Thread.currentThread();
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
        if (this.isWaiting) {
            try {
                if (this.conn != null) {
                    this.conn.disconnect();
                }
                if (this.is != null) {
                    this.is.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.error = "Timeout";
        }
        if (this.error != null) {
            throw new Exception(this.error);
        }
        return this.res.toString();
    }

    @Override
    public void run() {
        try {
            if (this.is == null) {
                this.is = Util.openStream(this.url, false, true, (int)this.timeout);
            }
            if (this.length != 0) {
                int n;
                byte[] buf = new byte[512];
                while ((n = this.is.read(buf)) != -1) {
                    this.res.append(new String(buf, 0, n));
                    this.size += n;
                    if (this.length < 0 || this.size < this.length) continue;
                }
                this.is.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            this.error = e.toString();
            this.error = e.getMessage();
        }
        this.isWaiting = false;
    }
}

